import json
import os


SUPABASE_URL = "https://busavazqvqobphvkezti.supabase.co"
SUPABASE_ANON_KEY = "sb_publishable_1dzb9acBr4QPofshCFJRyA_BXifSk5P"


def _load_local_overrides():
    config_path = os.path.join(os.path.dirname(__file__), "config.local.json")
    if not os.path.exists(config_path):
        return
    try:
        with open(config_path, "r", encoding="utf-8") as handle:
            data = json.load(handle)
        if isinstance(data, dict):
            url = str(data.get("SUPABASE_URL", "")).strip()
            anon = str(data.get("SUPABASE_ANON_KEY", "")).strip()
            if url:
                globals()["SUPABASE_URL"] = url
            if anon:
                globals()["SUPABASE_ANON_KEY"] = anon
    except Exception:
        return


_load_local_overrides()
